function sys_state = FTC_closed_sys_performance(t,xx,A,B,Fa,D,C,Fs,Delta_A,Kx,M,H,R,G)
hat_eta = xx(1);
xi1 = xx(2);
xi2 = xx(3);
x1 = xx(4);
x2 = xx(5);

global Int_ffa Int_ffs Int_yy1 Int_yy2 Int_ts Int_count Int_tmp Int_hatfa Int_hatfs  Int_u

E = pinv(B)*Fa;

Y = 0.5*ones(1,2);
N = pinv(B) - Y * (eye(2) - B*pinv(B));

psi = 0.001; 
omega =  7.8772; 
phi = omega*psi + 0.1;

varep1 = 0.2;
varep2 = 1.0e-1; 
sigma = 2;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% disturbance and fault
d = 0.01 * sin(0.1*t);
fa = piecewise_fa(t); % 
fs = piecewise_fs(t); % 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
x = [x1;x2];
% bar_x = [x1;x2;fa;fs];
y = C*x + Fs*fs;
xi = [xi1;xi2];
hat_z = xi + H*y;

% sliding surface
s_t = N*x;

% controller
u_l = - Kx*x - E*hat_z(1);
rho1 = hat_eta + varep1 + phi;
u_n = -rho1 * (s_t / (norm(s_t,2) + varep2));
u = u_l + u_n;

dot_hat_eta = sigma * norm(s_t,2);

%observer
dot_xi = M* xi + G*u + R*y;

% sys dynamic
dot_x = (A + Delta_A)*x + B*u + Fa*fa + D*d;
y0 = y - Fs*hat_z(2);

% data saving 
if mod(Int_tmp,10)==0
    Int_count = Int_count + 1;
Int_ts(Int_count) = t;
Int_ffa(Int_count) = fa;
Int_ffs(Int_count) = fs;
Int_yy1(Int_count) = y0(1);
Int_yy2(Int_count) = y0(2);
Int_hatfa(Int_count) = fa - hat_z(1);
Int_hatfs(Int_count) = fs - hat_z(2);
Int_u(Int_count) = u;
end
Int_tmp = Int_tmp + 1;

sys_state = [dot_hat_eta;dot_xi;dot_x];